// Autor: Tonko Sabolcec

#include <cassert>
#include <cstdio>
#include <cstring>
#include <vector>
#include <algorithm>

#define x first
#define y second
#define is_empty blablabla

using namespace std;

const int N = 1510;

int n, m;
char grid[N][N];

struct Tree {
  int tm;
  int lo[N][N];
  int hi[N][N];
  int fenwick[N*N];
  
  vector<pair<int, int>> children[N][N];
  bool vis[N][N];

  Tree() : tm(0) {
  }
  
  void fenwick_update(int p, int v) {
    for (++p; p < N*N; p += p & -p)
      fenwick[p] += v;
  }

  int fenwick_query(int p) {
    int ret = 0;
    for (++p; p > 0; p -= p & -p)
      ret += fenwick[p];
    return ret;
  }

  void insert(int x, int y) {
    fenwick_update(hi[x][y], 1);
  }

  void erase(int x, int y) {
    if (vis[x][y]) return;
    vis[x][y] = true;
    fenwick_update(hi[x][y], -1);
  }

  int count(int x, int y) {
    if (grid[x][y] != 'X') return -1;
    return fenwick_query(hi[x][y]) - fenwick_query(lo[x][y]);
  }

  void dfs(int x, int y) {
    lo[x][y] = tm;
    for (auto c : children[x][y]) {
      dfs(c.x, c.y);
    }
    hi[x][y] = ++tm;
  }

  void build(int x, int y, vector<pair<int, int>> directions) {
    for (int i = 0; i < n; ++i) {
      for (int j = 0; j < m; ++j) {
        for (auto d : directions) {
          int ii = i + d.x;
          int jj = j + d.y;
          if (ii < 0 || jj < 0 || ii >= n || jj >= m) continue;
          if (grid[ii][jj] == 'X') {
            children[ii][jj].push_back({i, j});
            break;
          }
        }
      }
    }
    dfs(x, y);
    for (int i = 0; i < n; ++i)
      for (int j = 0; j < m; ++j)
        if (grid[i][j] == 'X')
          insert(i, j);
    memset(vis, 0, sizeof vis);
  }

  void clear() {
    tm = 0;
    memset(lo, 0, sizeof lo);
    memset(hi, 0, sizeof hi);
    memset(vis, 0, sizeof vis);
    memset(fenwick, 0, sizeof fenwick);
    for (int i = 0; i < n; ++i)
      for (int j = 0; j < m; ++j)
        children[i][j].clear();
  }
} P, K;


// popis svih tocaka koje cine najgornji put
vector<pair<int, int>> path;
// popis svih pozicija (indexa u path-u) koje smijem obrisat u sljedecem koraku
vector<int> empty;
// koristim cisto da ne brisem 2 put isto polje
bool mark[N][N];

// provjeri ako smijem obrisati polje (x, y)
inline bool is_empty(int x, int y) {
  return !mark[x][y] && !P.count(x, y) && !K.count(x, y);
}

// stavi polje u listu za brisanje
inline void set_empty(int x, int y, vector<int> &emp) {
  mark[x][y] = true;
  emp.push_back(x + y);
}

// pronalazi pocetni najgornji put i polja koja se smiju obrisat
void init_path() {
  path.resize(n+m-1);
  {
    int x = 0, y = 0;
    for (int i = 0; i < n+m-1; ++i) {
      P.erase(x, y);
      K.erase(x, y);
      path[i] = {x, y};
      if (x == n-1 || (y < m-1 && grid[x][y+1] == 'X')) ++y;
      else ++x;
    }
  }
  empty.clear();
  for (auto p : path) {
    if (is_empty(p.x, p.y)) {
      set_empty(p.x, p.y, empty);
    }
  }
}

// na temelju polja koja brise, updejta najgornji put i popis sljedecih polja za brisanje
void update_path() {
  vector<int> nempty;
  sort(empty.begin(), empty.end());
  int sz = (int)empty.size();
  int lt = 0, rt = 0;
  
  // obrisi X-eve u trenutnom najgornji putu i skuzi sljedeci najgornji put
  while (lt < sz) {
    while (rt < sz && empty[rt] + lt == empty[lt] + rt) {
      auto p = path[empty[rt]];
      grid[p.x][p.y] = '.';
      rt++;
    }
    int x = path[empty[lt]].x + 1;
    int y = path[empty[lt]].y - 1;
    if (x < n && y >= 0) {
      assert(grid[x][y] == 'X');
      for (int i = lt; i < rt; ++i) {
        P.erase(x, y);
        K.erase(x, y);
        path[x+y] = {x, y};
        if (x == n-1 || (y < m-1 && grid[x][y+1] == 'X')) ++y;
        else ++x;
      }
    }
    lt = rt;
  }

  // skuzi koja polja u najgornjem putu smijes izbrisat u slj. koraku
  lt = rt = 0;
  while (lt < sz) {
    while (rt < sz && empty[rt] + lt == empty[lt] + rt) {
      auto p = path[empty[rt]];
      if (is_empty(p.x, p.y)) {
        set_empty(p.x, p.y, nempty);
      }
      rt++;
    }
      
    int l = empty[lt] - 1;
    int r = empty[lt] + rt - lt;
    for (; l >= 0 && is_empty(path[l].x, path[l].y); --l) {
      set_empty(path[l].x, path[l].y, nempty);
    }
    for (; r < n+m-1 && is_empty(path[r].x, path[r].y); ++r) {
      set_empty(path[r].x, path[r].y, nempty);
    }
    lt = rt;
  }
  empty = nempty;
}

void clear() {
  P.clear();
  K.clear();
  empty.clear();
  path.clear();
  memset(mark, 0, sizeof mark);
}

void debug() {
  printf("\n");
  for (int i = 0; i < n; ++i)
    printf("%s\n", grid[i]);
}

int main(void) {
  int tests;
  scanf("%d", &tests);

  while (tests--) {
    scanf("%d%d", &n, &m);
    for (int i = 0; i < n; ++i)
      scanf("%s", grid[i]);

    P.build(0, 0, vector<pair<int, int>>{{0, -1}, {-1, 0}});
    K.build(n-1, m-1, vector<pair<int, int>>{{1, 0}, {0, 1}});

    int ans = 0;
    init_path();
    while (grid[0][0] == 'X') {
      update_path();
      ans++;
      //debug();
    }
    printf("%d\n", ans);
    clear();
  }
  return 0;
}
